<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCertConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cert_configs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('resource_link_id');
            $table->string('title');
            $table->string('content');
            $table->string('body');
            $table->string('background');
            $table->string('typography');
            $table->enum('orientation', ['HORIZONTAL','VERTICAL']);
            $table->string('font_color');
            $table->string('font_size');
            $table->enum('context', ['PUBLIC','PRIVATE'])->default('PRIVATE');
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('resource_link_id')->references('id')->on('resource_links')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cert_configs');
    }
}
