<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id('id');
            $table->foreignId('platform_id');
            $table->uuid('lti_id')->index();
            $table->string('password')->nullable();
            $table->string('name');
            $table->string('given_name');
            $table->string('family_name');
            $table->string('email')->nullable();
            $table->string('picture');
            $table->text('roles');
            $table->string('person_sourceid')->nullable();
            $table->enum('creation_method',['LTI','MANUAL'])->default('LTI');
            $table->rememberToken();
            $table->timestamps();
            $table->foreign('platform_id')->references('id')->on('platforms')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
