<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Traits\LtiRolesManager;
use Illuminate\Database\Eloquent\Relations\HasMany;

class User extends Authenticatable
{
    use HasFactory, Notifiable, LtiRolesManager;

    protected $fillable = ['platform_id','lti_id', 'password', 'name', 'given_name', 'family_name',
    'email', 'picture', 'roles', 'person_sourceid', 'creation_method'];
    protected $hidden = ['password', 'remember_token'];

    public function platform() : BelongsTo {
        return $this->belongsTo(Platform::class, 'platform_id');
    }

    public function issuedCerts() : HasMany {
        return $this->hasMany(IssuedCert::class, 'user_id', 'id');
    }
}
