<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CertLog extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'resource_link_id', 'cert_config_id', 'context'];

    public function user() : BelongsTo {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function resourceLink() : BelongsTo {
        return $this->belongsTo(ResourceLink::class, 'resource_link_id');
    }

    public function certConfig() : BelongsTo {
        return $this->belongsTo(CertConfig::class, 'cert_config_id');
    }
}
