<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class CertConfig extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['resource_link_id', 'title', 'content', 'body', 'background',
    'typography', 'orientation', 'font_color', 'font_size', 'context'];

    public function issuedCerts() : HasMany{
        return $this->HasMany(IssuedCert::class, 'cert_config_id', 'id');
    }

    public function resourceLink() : BelongsTo {
        return $this->belongsTo(ResourceLink::class, 'resource_link_id');
    }
}
