<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ResourceLink;
use App\Models\CertConfig;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;

class CertController extends Controller
{
    public function showConfig(int $resourceLinkId) : View {
        $resourceLink = ResourceLink::findOrFail($resourceLinkId)
                        ->with('certConfig')->first();
        $certConfig = $resourceLink->certConfig;
        return View('cert_manager.config')->with([
            'resourceLink' => $resourceLink,
            'certConfig' => $certConfig,
            'tab' => 'config'
        ]);
    }

    public function showIssued(int $resourceLinkId) : View {
        $resourceLink = ResourceLink::findOrFail($resourceLinkId)
        ->with(['certConfig' => function($query){
            return $query->with('issuedCerts');
        }])->first();
        $certConfig = $resourceLink->certConfig;
        $issuedCerts = !empty($certConfig) ? $certConfig->issuedCerts : null;
        return View('cert_manager.list')->with([
            'resourceLink' => $resourceLink,
            'certConfig' => $certConfig,
            'issuedCerts' => $issuedCerts,
            'tab' => 'issued'
        ]);
    }

    public function saveConfig(Request $request){
        // Guardamos la configuración del certificado
        dump("saveConfig");
        dd($request->all());
    }

    public function buildCert(int $resourceLinkId){
        // Acá construimos el certificado o en su defecto rescatamos la Id
        // si este ya existe
        return redirect()->route('cert.show', ['certificateId' => 1]);
    }

    public function viewCert(int $resourceLinkId){
        // Acá traemos la id
        return View('cert_owner.show');
    }
}
