<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppStartController;
use App\Http\Controllers\CertController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::group(['prefix' => 'lti'], function () {
    Route::post('/connect', [AppStartController::class, "connect"])->name('lti.connect');
});

Route::group(['prefix' => 'certificate', 'middleware' => ['auth']], function () {
    Route::get('list/{resourceLinkId}', [CertController::class, "showIssued"])
        ->middleware('can:viewCertIssuedList, App\Models\IssuedCert')
        ->name('cert.issuedList');

    Route::get('build/{resourceLinkId}', [CertController::class, "buildCert"])
        ->middleware('can:obtainACert, App\Models\IssuedCert')
        ->name('cert.build');

    Route::get('view/{certificateId}', [CertController::class, "viewCert"])
        ->middleware('can:viewCert, App\Models\IssuedCert')
        ->name('cert.show');
});

Route::group(['prefix' => 'certificate/config', 'middleware' => ['auth']], function () {
    Route::get('/{resourceLinkId}', [CertController::class, "showConfig"])
        ->middleware('can:manageCertConfigs, App\Models\CertConfig')
        ->name('cert.config');

    Route::post('/save', [CertController::class, "saveConfig"])
        ->middleware('can:manageCertConfigs, App\Models\CertConfig')
        ->name('cert.saveConfig');
});

