<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class IssuedCertPolicy
{
    use HandlesAuthorization;

    public function viewCertIssuedList(User $user){
        $can = $user->isAdmin() || $user->isInstructor(User::$CONTEX_ROLES);
        return $can;
    }

    public function obtainACert(User $user){
        return $user->isLearner(User::$CONTEX_ROLES);
    }

    public function viewCert(User $user){
        $can = $user->isAdmin() || $user->isInstructor(User::$CONTEX_ROLES) ||
               $user->isLearner(User::$CONTEX_ROLES);
        return $can;
    }
}
