<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class IssuedCert extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['user_id', 'cert_config_id', 'filename', 'validation_code'];

    public function certConfig() : BelongsTo {
        return $this->belongsTo(CertConfig::class, 'cert_config_id');
    }

    public function user () : BelongsTo {
        return $this->belongsTo(User::class, 'user_id');
    }
}
