<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LTILoginInitiation extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // Params for Login Hint
            'login_hint' => 'nullable|string',
            'iss' => 'required_if:login_hint,1|string',
            'client_id' => 'required_if:login_hint,1|string',
            'target_link_uri' => 'required_if:login_hint,1|string',
            'lti_message_hint' => 'required_if:login_hint,1|string',
            // Params of lti "session"
            'id_token' => 'required_without:login_hint|string',
            'state' => 'required_if:id_token,1|string'
        ];
    }
}
